<?php 
ob_start();
session_start();

include 'config.php';
include '../admin/fonksiyon.php';

// Admin Girişi
if (isset($_POST['adminlogin'])) {
    $admin_mail = $_POST['admin_mail'];
    $admin_password = md5($_POST['admin_password']);
    
    $adminsor = $db->prepare("SELECT * FROM admin WHERE admin_mail = :mail AND admin_password = :password AND admin_yetki = :yetki");
    $adminsor->execute(array(
        'mail' => $admin_mail,
        'password' => $admin_password,
        'yetki' => 6
    ));
    
    $say = $adminsor->rowCount();
    
    if ($say == 1) {
        $_SESSION['admin_mail'] = $admin_mail;
        header("Location: ../admin/index.php");
        exit;
    } else {
        header("Location: ../admin/login.php?durum=basarisiz");
        exit;
    }
}

// Ürün Stok Arttırma
if (isset($_GET['urun_id']) && isset($_GET['arttir'])) {
    urunStokArttir($_GET['urun_id']);
}

// Ürün Stok Azaltma
if (isset($_GET['urun_id']) && isset($_GET['azalt'])) {
    urunStokAzalt($_GET['urun_id']);
}

// Ürün Stok Arttırma Fonksiyonu
function urunStokArttir($urun_id) {
    global $db;
    $arttir_query = $db->prepare("UPDATE urun SET urun_stok = urun_stok + 1 WHERE urun_id = :urun_id");
    $arttir_query->bindParam(':urun_id', $urun_id, PDO::PARAM_INT);

    if ($arttir_query->execute()) {
        header("Location: ../admin/urun.php?durum=success&mesaj=artirildi");
        exit;
    } else {
        header("Location: ../admin/urun.php?durum=fail&mesaj=Hata oluştu. Lütfen tekrar deneyin.");
        exit;
    }
}


// Ürün Stok Azaltma Fonksiyonu
function urunStokAzalt($urun_id) {
    global $db;
    $stok_sorgu = $db->prepare("SELECT urun_stok FROM urun WHERE urun_id = :urun_id");
    $stok_sorgu->bindParam(':urun_id', $urun_id, PDO::PARAM_INT);
    $stok_sorgu->execute();
    $stok_miktari = $stok_sorgu->fetchColumn();

    if ($stok_miktari > 0) {
        $azalt_query = $db->prepare("UPDATE urun SET urun_stok = urun_stok - 1 WHERE urun_id = :urun_id");
        $azalt_query->bindParam(':urun_id', $urun_id, PDO::PARAM_INT);

        if ($azalt_query->execute()) {
            header("Location: ../admin/urun.php?durum=ok");
            exit;
        } else {
            header("Location: ../admin/urun.php?durum=no");
            exit;
        }
    } else {
        header("Location: ../admin/urun.php?durum=no");
        exit;
    }
}

// ürün düzenleme

if (isset($_POST['urunduzenleme'])) {

	$urun_id=$_POST['urun_id'];
	$urun_seourl=seo($_POST['urun_ad']);

	$kaydet=$db->prepare("UPDATE urun SET
		kategori_id=:kategori_id,
        firma_id=:firma_id,
		urun_ad=:urun_ad,
		urun_detay=:urun_detay,
		urun_serino=:urun_serino,
		urun_durum=:urun_durum,
		urun_stok=:urun_stok,
		urun_seourl=:seourl		
		WHERE urun_id={$_POST['urun_id']}");
	$update=$kaydet->execute(array(
		'kategori_id' => $_POST['kategori_id'],
        'firma_id' => $_POST['firma_id'],
		'urun_ad' => $_POST['urun_ad'],
		'urun_detay' => $_POST['urun_detay'],
		'urun_serino' => $_POST['urun_serino'],
		'urun_durum' => $_POST['urun_durum'],
		'urun_stok' => $_POST['urun_stok'],
		'seourl' => $urun_seourl
		));

	if ($update) {

		Header("Location:../admin/urun.php?durum=ok&urun_id=$urun_id");

	} else {

		Header("Location:../admin/urun.php?durum=no&urun_id=$urun_id");
	}

}

// Logo Güncelleme
if (isset($_POST['logoduzenle'])) {
    $uploads_dir = '../../img';
    @$tmp_name = $_FILES['settings_logo']["tmp_name"];
    @$name = $_FILES['settings_logo']["name"];
    
    $benzersizsayi4 = rand(20000, 32000);
    $refimgyol = substr($uploads_dir, 6) . "/" . $benzersizsayi4 . $name;
    
    @move_uploaded_file($tmp_name, "$uploads_dir/$benzersizsayi4$name");
    
    $duzenle = $db->prepare("UPDATE settings SET settings_logo = :logo WHERE settings_id = 0");
    $update = $duzenle->execute(array('logo' => $refimgyol));

    if ($update) {
        $resimsilunlink = $_POST['eski_yol'];
        unlink("../../$resimsilunlink");
        header("Location: ../admin/genel-ayar.php?durum=ok"); 
    } else {
        header("Location: ../admin/genel-ayar.php?durum=no");
    }
}

// Genel Ayarları Kaydetme
if (isset($_POST['genelayarkaydet'])) {
    $ayarkaydet = $db->prepare("UPDATE settings SET 
        settings_title = :settings_title,
        settings_description = :settings_description,
        settings_keywords = :settings_keywords,
        settings_author = :settings_author
        WHERE settings_id = 0");
    
    $update = $ayarkaydet->execute(array(
        'settings_title' => $_POST['settings_title'],
        'settings_description' => $_POST['settings_description'],
        'settings_keywords' => $_POST['settings_keywords'],
        'settings_author' => $_POST['settings_author']
    ));

    if ($update) {
        header("Location: ../admin/genel-ayar.php?durum=ok");
    } else {
        header("Location: ../admin/genel-ayar.php?durum=no");
    }
}

// Ürün Ekleme
if (isset($_POST['urunekle'])) {
    $urun_seourl = seo($_POST['urun_ad']);
    $kaydet = $db->prepare("INSERT INTO urun SET
        kategori_id = :kategori_id,
        firma_id = :firma_id,
        urun_ad = :urun_ad,
        urun_detay = :urun_detay,
        urun_durum = :urun_durum,
        urun_stok = :urun_stok,
        urun_seourl = :seourl");
    $insert = $kaydet->execute(array(
        'kategori_id' => $_POST['kategori_id'],
        'firma_id' => $_POST['firma_id'],
        'urun_ad' => $_POST['urun_ad'],
        'urun_detay' => $_POST['urun_detay'],
        'urun_durum' => $_POST['urun_durum'],
        'urun_stok' => $_POST['urun_stok'],
        'seourl' => $urun_seourl
    ));

    if ($insert) {
        header("Location: ../admin/urun.php?durum=ok");
    } else {
        header("Location: ../admin/urun-ekle.php?durum=no");
    }
}


// Ürün Silme
if (isset($_GET['urundelete'])) {
    $urun_id = $_GET['urun_id'];

    // Ürün ID'sinin geçerli olup olmadığını kontrol edin
    if (isset($urun_id) && is_numeric($urun_id)) {
        // Ürünü silme sorgusu
        $stmt = $db->prepare("DELETE FROM urun WHERE urun_id = :urun_id");
        $stmt->bindParam(':urun_id', $urun_id, PDO::PARAM_INT);

        if ($stmt->execute()) {
            // Başarılı silme işlemi için yönlendirme
            header('Location: ../admin/urun.php?durum=ok');
            exit;
        } else {
            // Hata durumu
            header('Location: ../admin/urun.php?durum=no');
            exit;
        }
    } else {
        // Geçersiz ID durumu
        header('Location: ../admin/urun.php?durum=gecersiz');
        exit;
    }
}

/// Tüm Ürünleri Sil
if (isset($_GET['sil']) && $_GET['sil'] === 'all') {
    // Tüm ürünleri silme sorgusu
    $sil = $db->prepare("DELETE FROM urun");

    if ($sil->execute()) {
        // Başarılı silme işlemi için yönlendirme
        header("Location: ../admin/urun.php?durum=ok&message=all_deleted");
        exit;
    } else {
        // Hata durumu
        header("Location: ../admin/urun.php?durum=no&message=delete_failed");
        exit;
    }
}

if (isset($_POST['urun_id']) && isset($_POST['personel_id']) && isset($_POST['miktar']) && isset($_POST['kullanim_yeri']) && isset($_POST['amac'])) {
    $urun_id = $_POST['urun_id'];
    $personel_id = $_POST['personel_id'];
    $miktar = $_POST['miktar'];
    $kullanim_yeri = $_POST['kullanim_yeri'];
    $amac = $_POST['amac'];

    // Ürün stok bilgisini güncelle
    $urunGuncelle = $db->prepare("UPDATE urun SET urun_stok = urun_stok - :miktar WHERE urun_id = :urun_id");
    $urunGuncelle->bindParam(':miktar', $miktar, PDO::PARAM_INT);
    $urunGuncelle->bindParam(':urun_id', $urun_id, PDO::PARAM_INT);

    if ($urunGuncelle->execute()) {
        // Personel ürünü kullanmak için ekleme işlemi
        $personelEkle = $db->prepare("INSERT INTO urun_personel (urun_id, personel_id, miktar, kullanim_yeri, amac, azaltilan_tarih)
            VALUES (:urun_id, :personel_id, :miktar, :kullanim_yeri, :amac, NOW())");
        
        $personelEkle->bindParam(':urun_id', $urun_id, PDO::PARAM_INT);
        $personelEkle->bindParam(':personel_id', $personel_id, PDO::PARAM_INT);
        $personelEkle->bindParam(':miktar', $miktar, PDO::PARAM_INT);
        $personelEkle->bindParam(':kullanim_yeri', $kullanim_yeri, PDO::PARAM_STR);
        $personelEkle->bindParam(':amac', $amac, PDO::PARAM_STR);

        if ($personelEkle->execute()) {
            header("Location: ../admin/urun.php?durum=success");
            exit;
        } else {
            // Hata kontrolü
            $errorInfo = $personelEkle->errorInfo();
            echo "Hata: " . $errorInfo[2]; // Hata mesajını yazdır
            exit;
        }
    } else {
        // Hata kontrolü
        $errorInfo = $urunGuncelle->errorInfo();
        echo "Hata: " . $errorInfo[2]; // Hata mesajını yazdır
        exit;
    }
}



// Personel Düzenleme
if (isset($_POST['personelduzenle'])) {
    $personel_id = $_POST['personel_id']; // Düzenlenecek personelin ID'sini alıyoruz

    $kaydet = $db->prepare("UPDATE personel SET
        personel_ad = :personel_ad,
        personel_detay = :personel_detay,
        personel_durum = :personel_durum
        WHERE personel_id = :personel_id");

    $update = $kaydet->execute(array(
        'personel_ad' => $_POST['personel_ad'],
        'personel_detay' => $_POST['personel_detay'],
        'personel_durum' => $_POST['personel_durum'],
        'personel_id' => $personel_id
    ));

    if ($update) {
        header("Location: ../admin/personel-duzenle.php?personel_id=$personel_id&durum=ok");
    } else {
        header("Location: ../admin/personel-duzenle.php?personel_id=$personel_id&durum=no");
    }
}

// Personel Silme
if (isset($_GET['personel_id']) && $_GET['personel_sil'] === 'ok') {
    $personel_id = $_GET['personel_id'];
    
    $sil = $db->prepare("DELETE FROM personel WHERE personel_id = :id");
    $sil->bindParam(':id', $personel_id, PDO::PARAM_INT);
    $sil->execute();

    if ($sil->rowCount()) {
        echo "Silme işlemi başarılı.";
        header("Location:  ../admin/personel.php?durum=basarili"); // Silme işleminden sonra sayfayı yenileyebilirsiniz
        exit;
    } else {
        echo "Silme işlemi başarısız oldu.";
    }
}



// Personel Ekleme
if (isset($_POST['personelekle'])) {
    $kaydet = $db->prepare("INSERT INTO personel SET
        personel_ad = :personel_ad,
        personel_detay = :personel_detay,
        personel_durum = :personel_durum");
        
    $insert = $kaydet->execute(array(
        'personel_ad' => $_POST['personel_ad'],
        'personel_detay' => $_POST['personel_detay'],
        'personel_durum' => $_POST['personel_durum'],
    ));


    if ($insert) {
        header("Location: ../admin/personel.php?durum=ok");
    } else {
        header("Location: ../admin/personel.php?durum=no");
    }
}


// personel Silme
if (isset($_GET['personeldelete'])) {
    $personel_id = $_GET['personel_id'];

    // personel ID'sinin geçerli olup olmadığını kontrol edin
    if (isset($personel_id) && is_numeric($personel_id)) {
        // personel silme sorgusu
        $stmt = $db->prepare("DELETE FROM personel WHERE personel_id = :personel_id");
        $stmt->bindParam(':personel_id', $personel_id, PDO::PARAM_INT);

        if ($stmt->execute()) {
            // Başarılı silme işlemi için yönlendirme
            header('Location: ../admin/personel.php?durum=ok');
            exit;
        } else {
            // Hata durumu
            header('Location: ../admin/personel.php?durum=no');
            exit;
        }
    } else {
        // Geçersiz ID durumu
        header('Location: ../admin/personel.php?durum=gecersiz');
        exit;
    }
}

/// Tüm personel Sil
if (isset($_GET['sil']) && $_GET['sil'] === 'all') {
    // Tüm personel silme sorgusu
    $sil = $db->prepare("DELETE FROM personel");

    if ($sil->execute()) {
        // Başarılı silme işlemi için yönlendirme
        header("Location: ../admin/personel.php?durum=ok&message=all_deleted");
        exit;
    } else {
        // Hata durumu
        header("Location: ../admin/personel.php?durum=no&message=delete_failed");
        exit;
    }
}

if (isset($_GET['urun_ids'])) {
    $urun_ids = explode(',', $_GET['urun_ids']);
    
    if (!empty($urun_ids)) {
        // ID'leri güvenli bir şekilde hazırlamak için placehold kullan
        $placeholders = implode(',', array_fill(0, count($urun_ids), '?'));
        
        $sil = $db->prepare("DELETE FROM urun WHERE urun_id IN ($placeholders)");

        if ($sil->execute($urun_ids)) {
            header("Location: ../admin/urun.php?durum=ok&message=selected_deleted");
            exit;
        } else {
            header("Location: ../admin/urun.php?durum=no&message=delete_failed");
            exit;
        }
    }
}

if (isset($_GET['sil']) && $_GET['sil'] === 'all') {
    $sil = $db->prepare("DELETE FROM urun");
    $kontrol = $sil->execute();
    
    if ($kontrol) {
        header("Location: ../admin/urun.php?durum=ok&message=all_deleted");
    } else {
        header("Location: ../admin/urun.php?durum=no&message=delete_failed");
    }
}

// Kategori Ekleme
if (isset($_POST['kategoriekle'])) {

	$kategori_seourl=seo($_POST['kategori_ad']);

	$kaydet=$db->prepare("INSERT INTO kategori SET
		kategori_ad=:ad,
		kategori_durum=:kategori_durum,	
		kategori_seourl=:seourl,
		kategori_sira=:sira
		");
	$insert=$kaydet->execute(array(
		'ad' => $_POST['kategori_ad'],
		'kategori_durum' => $_POST['kategori_durum'],
		'seourl' => $kategori_seourl,
		'sira' => $_POST['kategori_sira']		
		));

	if ($insert) {

		Header("Location:../admin/kategori.php?durum=Başarılı");

	} else {

		Header("Location:../admin/kategori.php?durum=Başarısız");
	}

}      


// Kategori Güncelleme
if (isset($_POST['kategoriduzenle'])) {
    $kategori_id = $_POST['kategori_id'];
    $kategori_seourl = seo($_POST['kategori_ad']);

    $kaydet = $db->prepare("UPDATE kategori SET
        kategori_ad = :kategori_ad,
        kategori_durum = :kategori_durum,    
        kategori_seourl = :seourl,
        kategori_sira = :sira
        WHERE kategori_id = :kategori_id");
    $update = $kaydet->execute(array(
        'kategori_ad' => $_POST['kategori_ad'],
        'kategori_durum' => $_POST['kategori_durum'],
        'seourl' => $kategori_seourl,
        'sira' => $_POST['kategori_sira'],
        'kategori_id' => $kategori_id        
    ));

    if ($update) {
        header("Location: ../admin/kategori.php?durum=ok&kategori_id=$kategori_id");
    } else {
        header("Location: ../admin/kategori.php?durum=no&kategori_id=$kategori_id");
    }
}

// Kategori Silme
if (isset($_GET['kategoridelete'])) {
    if (isset($_GET['kategori_id']) && is_numeric($_GET['kategori_id'])) {
        $delete = $db->prepare("DELETE FROM kategori WHERE kategori_id = :id");
        $kontrol = $delete->execute(array('id' => $_GET['kategori_id']));
        header("Location: ../admin/kategori.php?" . ($kontrol ? "delete=ok" : "delete=no"));
    }
}

// Firma Ekleme
if (isset($_POST['firmaekle'])) {

	$firma_seourl=seo($_POST['firma_ad']);

	$kaydet=$db->prepare("INSERT INTO firma SET
		firma_ad=:ad,
		firma_durum=:firma_durum,	
		firma_seourl=:seourl,
		firma_sira=:sira
		");
	$insert=$kaydet->execute(array(
		'ad' => $_POST['firma_ad'],
		'firma_durum' => $_POST['firma_durum'],
		'seourl' => $firma_seourl,
		'sira' => $_POST['firma_sira']		
		));

	if ($insert) {

		Header("Location:../admin/firma.php?durum=Başarılı");

	} else {

		Header("Location:../admin/firma.php?durum=Başarısız");
	}

}    


// firma Düzenleme
if (isset($_POST['firmaduzenle'])) {
    $firma_id = $_POST['firma_id'];
    $firma_seourl = seo($_POST['firma_ad']);

    $kaydet = $db->prepare("UPDATE firma SET
        firma_ad = :firma_ad,
        firma_durum = :firma_durum,    
        firma_seourl = :seourl,
        firma_sira = :sira
        WHERE firma_id = :firma_id");
    $update = $kaydet->execute(array(
        'firma_ad' => $_POST['firma_ad'],
        'firma_durum' => $_POST['firma_durum'],
        'seourl' => $firma_seourl,
        'sira' => $_POST['firma_sira'],
        'firma_id' => $firma_id        
    ));

    if ($update) {
        header("Location: ../admin/firma.php?durum=ok&firma_id=$firma_id");
    } else {
        header("Location: ../admin/firma.php?durum=no&firma_id=$firma_id");
    }
}

// firma Silme
if (isset($_GET['firmadelete'])) {
    if (isset($_GET['firma_id']) && is_numeric($_GET['firma_id'])) {
        $delete = $db->prepare("DELETE FROM firma WHERE firma_id = :id");
        $kontrol = $delete->execute(array('id' => $_GET['firma_id']));
        header("Location: ../admin/firma.php?" . ($kontrol ? "delete=ok" : "delete=no"));
    }
}

// Çıkış Yap
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: ../admin/login.php");
    exit;
}

// Diğer kodlar...
// Genel Ayarları Alma
$ayarlar = $db->query("SELECT * FROM settings WHERE settings_id = 0")->fetch(PDO::FETCH_ASSOC);

// Ürünleri Listeleme
$urunler = $db->query("SELECT * FROM urun")->fetchAll(PDO::FETCH_ASSOC);

// Kategorileri Listeleme
$kategoriler = $db->query("SELECT * FROM kategori")->fetchAll(PDO::FETCH_ASSOC);

// Firmaları    Listeleme
$firmalar = $db->query("SELECT * FROM firma")->fetchAll(PDO::FETCH_ASSOC);

// Admin Bilgileri
$stmt = $db->prepare("SELECT * FROM admin WHERE admin_mail = :mail");
$stmt->execute(array(':mail' => $_SESSION['admin_mail']));
$admin = $stmt->fetch(PDO::FETCH_ASSOC);
?>
