<?php
include 'header.php';

// Sayfa numarası ve sayfa başına ürün sayısı
$sayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$sayfaBasiUrun = 20;
$limit = ($sayfa - 1) * $sayfaBasiUrun;

// Kategori bilgilerini çekme işlemi
$kategorisor = $db->prepare("SELECT * FROM kategori ORDER BY kategori_ad ASC");
$kategorisor->execute();

// Firma bilgilerini çekme işlemi
$firmaSorgu = $db->prepare("SELECT * FROM firma ORDER BY firma_ad ASC");
$firmaSorgu->execute();

// Seçilen kategori ve firmaya göre ürün listeleme işlemi
$kategori_id = isset($_GET['kategori_id']) ? $_GET['kategori_id'] : null;
$firma_id = isset($_GET['firma_id']) ? $_GET['firma_id'] : null;
$arama = isset($_GET['arama']) ? $_GET['arama'] : ''; // Arama terimini al

// Ürün sorgusunu oluştur
$urunSorgu = "SELECT urun.*, kategori.kategori_ad, firma.firma_ad 
              FROM urun 
              LEFT JOIN kategori ON urun.kategori_id = kategori.kategori_id 
              LEFT JOIN firma ON urun.firma_id = firma.firma_id 
              WHERE 1";

if ($kategori_id) {
    $urunSorgu .= " AND urun.kategori_id = :kategori_id";
}
if ($firma_id) {
    $urunSorgu .= " AND urun.firma_id = :firma_id";
}
if ($arama) {
    $urunSorgu .= " AND urun.urun_ad LIKE :arama"; // Arama sorgusuna ekle
}

$urunSorgu .= " ORDER BY urun_id DESC LIMIT :limit, :sayfaBasiUrun";
$urunsor = $db->prepare($urunSorgu);

if ($kategori_id) {
    $urunsor->bindParam(':kategori_id', $kategori_id, PDO::PARAM_INT);
}
if ($firma_id) {
    $urunsor->bindParam(':firma_id', $firma_id, PDO::PARAM_INT);
}
if ($arama) {
    $aramaParam = '%' . $arama . '%'; // Arama terimini wildcard ile birlikte tanımla
    $urunsor->bindParam(':arama', $aramaParam, PDO::PARAM_STR);
}
$urunsor->bindParam(':limit', $limit, PDO::PARAM_INT);
$urunsor->bindParam(':sayfaBasiUrun', $sayfaBasiUrun, PDO::PARAM_INT);
$urunsor->execute();

// Toplam ürün sayısını öğrenme (sayfalama için)
$toplamUrun = $db->prepare("SELECT COUNT(*) FROM urun WHERE 1" . 
    ($kategori_id ? " AND kategori_id = $kategori_id" : "") . 
    ($firma_id ? " AND firma_id = $firma_id" : "") . 
    ($arama ? " AND urun_ad LIKE :arama" : "")
);
if ($arama) {
    $toplamUrun->bindParam(':arama', $aramaParam, PDO::PARAM_STR);
}
$toplamUrun->execute();
$toplamUrun = $toplamUrun->fetchColumn();
$sayfaSayisi = ceil($toplamUrun / $sayfaBasiUrun);

// Başarı ve hata mesajları
if (isset($_GET['durum'])) {
    echo '<div class="alert ' . ($_GET['durum'] == 'success' ? 'alert-success' : 'alert-danger') . '">';
    echo $_GET['durum'] == 'success' ? 'İşlem başarıyla gerçekleştirildi.' : 'İşlem başarısız oldu.';
    echo '</div>';
}

// Toplam ürün sayısını al
$urunSayisi = $urunsor->rowCount(); // veya uygun bir sorgu ile
?>


<div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">
    <div class="row">
        <div class="col-lg-12">
            <h1 class="page-header">Ürünler</h1>
        </div>
    </div><!--/.row-->

   <!-- Başarı ve hata mesajları -->
<?php if (isset($_GET['durum'])): ?>
    <div class="alert <?php echo ($_GET['durum'] == 'success') ? 'alert-success' : 'alert-danger'; ?>">
        <?php 
        if ($_GET['durum'] == 'success') {
            if (isset($_GET['mesaj']) && $_GET['mesaj'] == 'artirildi') {
                echo 'Stok başarıyla artırıldı.'; // Artırma için yeşil başarı mesajı
            } else {
                echo 'Stok başarıyla azaltıldı.'; // Azaltma için başarı mesajı
            }
        } elseif ($_GET['durum'] == 'fail') {
            echo htmlspecialchars($_GET['mesaj']); // Hata mesajı gösterimi
        }
        ?>
    </div>
<?php endif; ?>


    <!-- Sağ üst köşede butonlar -->
    <div class="text-right mb-3">
        <a href="../kariyersoft/control.php?sil=all" class="btn btn-danger" style="margin-right: 10px;">Tüm Ürünleri Sil</a>
        <button type="button" class="btn btn-info" style="margin-right: 10px;" onclick="toggleSelectAll()">Tümünü Seç</button>
        
        <a href="../kariyersoft/control.php?urun_ids=<?php echo $veri['urun_id']; ?>" class="btn btn-success" style="margin-right: 10px;">Seçili Ürünleri Sil</a>
    </div>
    
    <!-- Kategori ve Firma seçimi -->
    <form action="" method="get" class="form-inline mb-3">
        <div class="form-group">
            <label for="kategori">Kategori Seç:</label>
            <select name="kategori_id" id="kategori" class="form-control mx-2">
                <option value="">Tüm Kategoriler</option>
                <?php while ($kategori = $kategorisor->fetch(PDO::FETCH_ASSOC)) { ?>
                    <option value="<?php echo $kategori['kategori_id']; ?>" <?php if ($kategori_id == $kategori['kategori_id']) echo 'selected'; ?>>
                        <?php echo $kategori['kategori_ad']; ?>
                    </option>
                <?php } ?>
            </select>
        </div>
<div class="form-group mx-3">
            <label for="firma">Firma Seç:</label>
            <select name="firma_id" id="firma" class="form-control mx-2">
                <option value="">Tüm Firmalar</option>
                <?php while ($firma = $firmaSorgu->fetch(PDO::FETCH_ASSOC)) { ?>
                    <option value="<?php echo $firma['firma_id']; ?>" <?php if ($firma_id == $firma['firma_id']) echo 'selected'; ?>>
                        <?php echo $firma['firma_ad']; ?>
                    </option>
                <?php } ?>
            </select>
        </div>

        <div class="form-group mx-3">
            <label for="arama">Ürün Ara:</label>
            <input type="text" name="arama" id="arama" class="form-control mx-2" value="<?php echo htmlspecialchars($arama); ?>" placeholder="Ürün Ara..." onkeyup="searchProducts()">
        </div>

        <button type="submit" class="btn btn-primary">Listele</button>
    </form>

    <div class="row">
    <div class="col-lg-12">
        <div class="panel panel-default">
            <div class="panel-heading" style="display: flex; align-items: center; justify-content: space-between;">
                <h4 style="margin: 0;">Ürün Listesi</h4>
                <p class="text-muted" style="color: #007bff; font-weight: bold; font-size: 16px;">
    Bu sayfada <?php echo $urunSayisi; ?> ürün listelenmektedir.
</p>

                
            </div>

            <div class="table-responsive">
                <table id="datatable-responsive" class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th>Seç</th>
                            <th>Ürün ID No</th>
                            <th>Ürün İsmi</th>
                            <th>Ürün Stok</th>
                            <th>Ürün Durum</th>
                            <th>Ürün Kategori</th>
                            <th>Ürün Bilgisi</th>
                            <th>Ürün Seri No</th>
                            <th>Ürün Firma</th>
                            <th>Ürün Eklenme Zamanı</th>
                            <th>Ürün Düzenle</th>
                            <th>Ürün Sil</th>
                            <th>Stok Arttır</th>
                            <th>Stok Azalt</th>
                        </tr>
                    </thead>
                    <tbody>
    <?php 
    while ($veri = $urunsor->fetch(PDO::FETCH_ASSOC)) {
        ?>
        <tr>
            <td><input type="checkbox" class="urun-checkbox" value="<?php echo $veri['urun_id']; ?>" onchange="updateSelectCount()"></td>
            <td><?php echo $veri['urun_id'] ?></td>
            <td><?php echo $veri['urun_ad'] ?></td>
            <td><?php echo $veri['urun_stok'] ?></td>
            <td>
                <?php 
                echo $veri['urun_durum'] == 1 
                    ? '<span class="label label-success">Aktif</span>'
                    : '<span class="label label-danger">Pasif</span>';
                ?>
            </td>
            <td><strong><?php echo $veri['kategori_ad'] ?></strong></td>
            <td><?php echo $veri['urun_detay'] ?></td>
            <td><?php echo $veri['urun_serino'] ?></td>
            <td><?php echo !empty($veri['firma_ad']) ? $veri['firma_ad'] : 'Firma Yok'; ?></td>
            <td><?php echo date('Y-m-d H:i:s', strtotime($veri['urun_zaman'])); ?></td> <!-- Eklenme tarihi -->
            <td><a href="urun-duzenle.php?urun_id=<?php echo $veri['urun_id']; ?>" class="btn btn-primary btn-xs">Düzenle</a></td>
            <td><a href="../kariyersoft/control.php?urun_id=<?php echo $veri['urun_id']; ?>&urundelete=ok" class="btn btn-danger btn-xs">Sil</a></td>
            <td><a href="../kariyersoft/control.php?urun_id=<?php echo $veri['urun_id']; ?>&arttir=1" class="btn btn-success btn-xs">Arttır</a></td>
            <td><a href="#" class="btn btn-danger btn-xs" onclick="showStockReduceModal(<?php echo $veri['urun_id']; ?>)">Azalt</a></td>
        </tr>
        <?php 
    }
    ?>
</tbody>

                </table>
            </div>

            <!-- Sayfalama -->
            <div class="text-center">
                <nav aria-label="Page navigation">
                    <ul class="pagination">
                        <?php for ($i = 1; $i <= $sayfaSayisi; $i++) : ?>
                            <li class="<?php echo ($sayfa == $i) ? 'active' : ''; ?>">
                                <a href="?sayfa=<?php echo $i; ?>&kategori_id=<?php echo $kategori_id; ?>&firma_id=<?php echo $firma_id; ?>"><?php echo $i; ?></a>
                            </li>
                        <?php endfor; ?>
                    </ul>
                </nav>
            </div>

        </div>
    </div>
</div><!--/.row-->


    <!-- Stok Azaltma Modal -->
    <div class="modal fade" id="stokAzaltModal" tabindex="-1" role="dialog" aria-labelledby="stokAzaltModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form id="stokAzaltForm" action="../kariyersoft/control.php" method="post">
                    <div class="modal-header">
                        <h5 class="modal-title" id="stokAzaltModalLabel">Stok Azalt</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="urun_id" id="modalUrunId">
                        <input type="hidden" name="azaltilan_tarih" id="modalAzaltilanTarih" value="<?php echo date('Y-m-d H:i:s'); ?>">
                        <div class="form-group">
                            <label for="modalMiktar">Miktar:</label>
                            <input type="number" name="miktar" id="modalMiktar" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label for="modalKullanimYeri">Kullanım Yeri:</label>
                            <input type="text" name="kullanim_yeri" id="modalKullanimYeri" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label for="modalAmac">Amaç:</label>
                            <input type="text" name="amac" id="modalAmac" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label for="modalPersonel">Personel Seç:</label>
                            <select name="personel_id" id="modalPersonel" class="form-control" required>
                                <option value="">Personel Seçin</option>
                                <?php
                                // Personel listesini çekin
                                $personelSorgu = $db->prepare("SELECT * FROM personel ORDER BY personel_ad ASC");
                                $personelSorgu->execute();
                                while ($personel = $personelSorgu->fetch(PDO::FETCH_ASSOC)) {
                                    echo "<option value=\"{$personel['personel_id']}\">{$personel['personel_ad']}</option>";
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Kapat</button>
                        <button type="submit" class="btn btn-primary">Stok Azalt</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</div><!--/.main-->

<script>
    function toggleSelectAll() {
        const checkboxes = document.querySelectorAll('.urun-checkbox');
        const allChecked = Array.from(checkboxes).every(checkbox => checkbox.checked);
        checkboxes.forEach(checkbox => checkbox.checked = !allChecked);
        updateSelectCount();
    }

    function showStockReduceModal(urunId) {
        document.getElementById('modalUrunId').value = urunId;
        $('#stokAzaltModal').modal('show');
    }

    function updateSelectCount() {
        const checkboxes = document.querySelectorAll('.urun-checkbox');
        const selectedCount = Array.from(checkboxes).filter(checkbox => checkbox.checked).length;
        document.getElementById('selectedCount').innerText = selectedCount;
    }
</script>
<script>
function searchProducts() {
    var arama = document.getElementById('arama').value;
    var kategori_id = document.getElementById('kategori').value;
    var firma_id = document.getElementById('firma').value;

    var xhr = new XMLHttpRequest();
    xhr.open('GET', '?arama=' + encodeURIComponent(arama) + '&kategori_id=' + kategori_id + '&firma_id=' + firma_id, true);
    xhr.onreadystatechange = function() {
        if (xhr.readyState == 4 && xhr.status == 200) {
            document.getElementById('urunListesi').innerHTML = xhr.responseText;
        }
    };
    xhr.send();
}

// Sayfa yüklendiğinde tüm ürünleri listele
window.onload = function() {
    searchProducts();
};
</script>

<?php
include 'footer.php';
?>
