<?php
include 'header.php';

// urun_id'yi kontrol et ve tanımla
$urun_id = isset($_GET['urun_id']) ? $_GET['urun_id'] : null;

$uruncek = null; // Ürün bilgisi başlangıçta boş

if ($urun_id !== null) {
    // Veritabanından ürün sorgulama
    $urunsor = $db->prepare("SELECT * FROM urun WHERE urun_id=:id");
    $urunsor->execute(array('id' => $urun_id));

    // Ürünün var olup olmadığını kontrol et
    $uruncek = $urunsor->fetch(PDO::FETCH_ASSOC);
}

// Eğer ürün yoksa veya ürün ID'si geçersizse hata mesajı göster
if ($uruncek === false) {
    echo "<div class='alert alert-danger'>Ürün bulunamadı veya geçersiz bir ürün ID'si verildi.</div>";
    exit;
}

// Kategori sorgusu
$kategorisor = $db->prepare("SELECT * FROM kategori WHERE kategori_ust=:kategori_ust ORDER BY kategori_sira");
$kategorisor->execute(array('kategori_ust' => 0));

// Firma sorgusu
$firmasor = $db->prepare("SELECT * FROM firma ORDER BY firma_ad");
$firmasor->execute();
?>

<script src="https://cdn.ckeditor.com/4.15.1/standard/ckeditor.js"></script>
<div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">
    <div class="row">
        <ol class="breadcrumb">
            <li><a href="#"><em class="fa fa-home"></em></a></li>
            <li class="active">Ürün Ayarlar</li>
        </ol>
    </div><!--/.row-->

    <div class="row">
        <div class="col-lg-12">
            <h1 class="page-header">Ürün Ayarlar</h1>
        </div>
    </div><!--/.row-->

    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <?php echo $urun_id !== null ? 'Ürünü Güncelle' : 'Yeni Ürün Ekle'; ?>
                    <?php if (isset($_GET['durum'])): ?>
                        <div class="pull-right">
                            <span class="label label-<?php echo ($_GET['durum'] == "ok") ? 'success' : 'danger'; ?>">
                                <?php echo ($_GET['durum'] == "ok") ? 'İşlem Başarılı' : 'İşlem Başarısız'; ?>
                            </span>
                        </div>
                    <?php endif; ?>
                </div>

                <div class="panel-body">
                    <form action="../kariyersoft/control.php" method="POST" enctype="multipart/form-data" data-parsley-validate class="form-horizontal form-label-left">
                        
                        <div class="form-group">
                            <label class="control-label col-md-3" for="kategori_id">Kategori Seç<span class="required">*</span></label>
                            <div class="col-md-6">
                                <select class="select2_multiple form-control" required="" name="kategori_id">
                                    <?php while ($kategoricek = $kategorisor->fetch(PDO::FETCH_ASSOC)): ?>
                                        <option value="<?php echo $kategoricek['kategori_id']; ?>" <?php echo ($uruncek && $uruncek['kategori_id'] == $kategoricek['kategori_id']) ? 'selected' : ''; ?>>
                                            <?php echo $kategoricek['kategori_ad']; ?>
                                        </option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                        </div>

                        <!-- Firma Seç -->
                        <div class="form-group">
                            <label class="control-label col-md-3" for="firma_id">Firma Seç<span class="required">*</span></label>
                            <div class="col-md-6">
                                <select class="select2_multiple form-control" required="" name="firma_id">
                                    <?php while ($firmacek = $firmasor->fetch(PDO::FETCH_ASSOC)): ?>
                                        <option value="<?php echo $firmacek['firma_id']; ?>" <?php echo ($uruncek && $uruncek['firma_id'] == $firmacek['firma_id']) ? 'selected' : ''; ?>>
                                            <?php echo $firmacek['firma_ad']; ?>
                                        </option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                        </div>

                        <fieldset>
                            <!-- Ürün İsmi -->
                            <div class="form-group">
                                <label class="col-md-3 control-label" for="urun_ad">Ürün İsmi *</label>
                                <div class="col-md-9">
                                    <input id="urun_ad" name="urun_ad" type="text" placeholder="Ürün İsmini Girin" class="form-control" value="<?php echo htmlspecialchars($uruncek['urun_ad'] ?? ''); ?>" required>
                                </div>
                            </div>

                            <!-- Ürün Bilgisi -->
                            <div class="form-group">
                                <label class="col-md-3 control-label" for="urun_detay">Ürün Bilgisi *</label>
                                <div class="col-md-9">
                                    <textarea class="ckeditor" id="editor1" name="urun_detay"><?php echo htmlspecialchars($uruncek['urun_detay'] ?? ''); ?></textarea>
                                </div>
                            </div>

                            <script type="text/javascript">
                                CKEDITOR.replace('editor1', {
                                    filebrowserBrowseUrl: 'ckfinder/ckfinder.html',
                                    filebrowserImageBrowseUrl: 'ckfinder/ckfinder.html?type=Images',
                                    filebrowserFlashBrowseUrl: 'ckfinder/ckfinder.html?type=Flash',
                                    filebrowserUploadUrl: 'ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files',
                                    filebrowserImageUploadUrl: 'ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Images',
                                    filebrowserFlashUploadUrl: 'ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Flash',
                                    forcePasteAsPlainText: true
                                });
                            </script>

                            

                            <!-- Ürün Seri No -->
                            <div class="form-group">
                                <label class="col-md-3 control-label" for="urun_serino">Ürün Seri No</label>
                                <div class="col-md-9">
                                    <input id="urun_serino" name="urun_serino" type="text" placeholder="Ürün Seri Numarasını Girin" class="form-control" value="<?php echo htmlspecialchars($uruncek['urun_serino'] ?? ''); ?>">
                                </div>
                            </div>

                            <!-- Ürün Stok -->
                            <div class="form-group">
                                <label class="col-md-3 control-label" for="urun_stok">Ürün Stok *</label>
                                <div class="col-md-9">
                                    <input id="urun_stok" name="urun_stok" type="text" placeholder="Ürün Stok Girin" class="form-control" value="<?php echo htmlspecialchars($uruncek['urun_stok'] ?? ''); ?>" required>
                                </div>
                            </div>

                            <!-- Ürün Durum -->
                            <div class="form-group">
                                <label class="col-md-3 control-label" for="urun_durum">Ürün Durum *</label>
                                <div class="col-md-9">
                                    <select id="urun_durum" class="form-control" name="urun_durum" required>
                                        <option value="1" <?php echo (isset($uruncek['urun_durum']) && $uruncek['urun_durum'] == 1) ? 'selected' : ''; ?>>Aktif</option>
                                        <option value="0" <?php echo (isset($uruncek['urun_durum']) && $uruncek['urun_durum'] == 0) ? 'selected' : ''; ?>>Pasif</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Form actions -->
                            <div class="form-group">
                                <div class="col-md-12 widget-right">
                                    <button type="submit" name="urunekle" class="btn btn-success btn-md pull-right">Kaydet</button>
                                    <button type="reset" class="btn btn-danger btn-md pull-right" style="margin-right: 10px;">Temizle</button>
                                </div>
                            </div>
                        </fieldset>
                    </form>
                </div>
            </div>
        </div><!--/.col-->
    </div><!--/.row-->
</div><!--/.main-->

<?php include 'footer.php'; ?>
