<?php
include 'header.php';

// Kategorileri çekmek için sorgu
$kategori_sorgu = $db->query("SELECT kategori_id, kategori_ad FROM kategori");
$kategoriler = $kategori_sorgu->fetchAll(PDO::FETCH_ASSOC);

// Sayfalama ayarları
$urun_sayisi = $db->query("SELECT COUNT(*) as count FROM urun")->fetch(PDO::FETCH_ASSOC)['count'];
$limit = 20; // Sayfa başına gösterilecek ürün sayısı
$toplam_sayfa = ceil($urun_sayisi / $limit);
$aktif_sayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$aktif_sayfa = max(1, min($toplam_sayfa, $aktif_sayfa)); // Geçerli sayfa kontrolü
$offset = ($aktif_sayfa - 1) * $limit;

// Ürünleri çekmek için sorgu
$kategori_id = isset($_GET['kategori_id']) ? $_GET['kategori_id'] : null;
$search_query = isset($_GET['search']) ? $_GET['search'] : '';

if ($kategori_id) {
    $urun_sorgu = $db->prepare("SELECT urun_id, urun_ad, urun_stok, kategori.kategori_ad FROM urun INNER JOIN kategori ON urun.kategori_id = kategori.kategori_id WHERE kategori.kategori_id = :kategori_id AND urun_ad LIKE :search LIMIT :limit OFFSET :offset");
    $urun_sorgu->bindParam(':kategori_id', $kategori_id, PDO::PARAM_INT);
} else {
    $urun_sorgu = $db->prepare("SELECT urun_id, urun_ad, urun_stok, kategori.kategori_ad FROM urun INNER JOIN kategori ON urun.kategori_id = kategori.kategori_id WHERE urun_ad LIKE :search LIMIT :limit OFFSET :offset");
}

$search_param = '%' . $search_query . '%';
$urun_sorgu->bindValue(':search', $search_param, PDO::PARAM_STR);
$urun_sorgu->bindValue(':limit', $limit, PDO::PARAM_INT);
$urun_sorgu->bindValue(':offset', $offset, PDO::PARAM_INT);
$urun_sorgu->execute();
$urunler = $urun_sorgu->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">
    <div class="row">
        <div class="col-lg-12">
            <h1 class="page-header">Ürünler</h1>
        </div>
    </div><!--/.row-->

    <div class="row">
        <div class="col-md-12">
            <!-- Kategori seçimi ve arama kutusu -->
            <form method="GET" action="" class="form-inline justify-content-between mb-3">
                <div class="form-group">
                    <label for="kategori" class="mr-2">Kategori Seç:</label>
                    <select name="kategori_id" id="kategori" class="form-control kategori-select" onchange="this.form.submit()">
                        <option value="">Tüm Kategoriler</option>
                        <?php foreach ($kategoriler as $kategori) : ?>
                            <option value="<?php echo htmlspecialchars($kategori['kategori_id']); ?>" 
                                <?php if ($kategori_id == $kategori['kategori_id']) echo 'selected'; ?>>
                                <?php echo htmlspecialchars($kategori['kategori_ad']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="search" class="mr-2">Ara:</label>
                    <input type="text" name="search" id="search" class="form-control" placeholder="Ürün Ara" value="<?php echo isset($_GET['search']) ? htmlspecialchars($_GET['search']) : ''; ?>">
                </div>
                <button type="submit" class="btn btn-primary">Ara</button>
            </form>

            <!-- Ürün listesi -->
            <table class="table table-striped table-bordered table-hover">
                <thead>
                    <tr>
                        <th>Ürün ID</th>
                        <th>Ürün Adı</th>
                        <th>Kategori</th>
                        <th>Stok Adedi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($urunler as $urun) : ?>
                        <tr>
                            <td><?php echo htmlspecialchars($urun['urun_id']); ?></td>
                            <td><?php echo htmlspecialchars($urun['urun_ad']); ?></td>
                            <td><strong class="kategori"><?php echo htmlspecialchars($urun['kategori_ad']); ?></strong></td>
                            <td><?php echo htmlspecialchars($urun['urun_stok']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            
            <!-- Çıktı Al Butonu -->
            <form method="POST" action="cikti.php">
                <center>
                    <button type="submit" class="btn btn-success">Çıktı Al</button>
                </center>
            </form>

            <!-- Sayfalama -->
            <div class="pagination">
                <?php for ($i = 1; $i <= $toplam_sayfa; $i++): ?>
                    <a href="?sayfa=<?php echo $i; ?>&kategori_id=<?php echo $kategori_id; ?>&search=<?php echo isset($_GET['search']) ? htmlspecialchars($_GET['search']) : ''; ?>" class="<?php echo ($i == $aktif_sayfa) ? 'active' : ''; ?>">
                        <?php echo $i; ?>
                    </a>
                <?php endfor; ?>
            </div>
        </div>
    </div><!--/.row-->
</div> <!--/.main-->

<style>
    .kategori {
        color: #007bff;
        font-weight: bold;
    }
    .btn-primary, .btn-success {
        margin-bottom: 20px;
    }
    .pagination {
        margin-top: 20px;
        text-align: center;
    }
    .pagination a {
        margin: 0 5px;
        padding: 10px 15px;
        border: 1px solid #007bff;
        border-radius: 4px;
        text-decoration: none;
        color: #007bff;
    }
    .pagination a.active {
        background-color: #007bff;
        color: #fff;
    }
</style>

<script>
    function tumunuSec() {
        var checkboxes = document.querySelectorAll('input[type="checkbox"]');
        checkboxes.forEach(function(checkbox) {
            checkbox.checked = true;
        });
    }
</script>

<?php include 'footer.php'; ?>
</html>
