<?php
include 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $urun_id = $_POST['urun_id'];
    $miktar = $_POST['miktar'];
    $personel_id = $_POST['personel_id'];
    $kullanım_yeri = $_POST['kullanım_yeri'];
    $amac = $_POST['amac'];

    // Ürün stokunu azalt
    $db->beginTransaction();
    try {
        // Stok güncelleme sorgusu
        $urunGuncelle = $db->prepare("UPDATE urun SET urun_stok = urun_stok - :miktar WHERE urun_id = :urun_id");
        $urunGuncelle->bindParam(':miktar', $miktar, PDO::PARAM_INT);
        $urunGuncelle->bindParam(':urun_id', $urun_id, PDO::PARAM_INT);
        $urunGuncelle->execute();

        // Personel kullanımı kaydı
        $kayitEkle = $db->prepare("INSERT INTO urun_personel (urun_id, personel_id, miktar, kullanım_yeri, amac) VALUES (:urun_id, :personel_id, :miktar, :kullanım_yeri, :amac)");
        $kayitEkle->bindParam(':urun_id', $urun_id, PDO::PARAM_INT);
        $kayitEkle->bindParam(':personel_id', $personel_id, PDO::PARAM_INT);
        $kayitEkle->bindParam(':miktar', $miktar, PDO::PARAM_INT);
        $kayitEkle->bindParam(':kullanım_yeri', $kullanım_yeri, PDO::PARAM_STR);
        $kayitEkle->bindParam(':amac', $amac, PDO::PARAM_STR);
        $kayitEkle->execute();

        $db->commit();
        echo "Stok güncellemesi başarılı.";
    } catch (Exception $e) {
        $db->rollBack();
        echo "Hata: " . $e->getMessage();
    }
}
?>
