<?php
include '../kariyersoft/config.php';
include 'header.php';

if (isset($_GET['urun_ad'])) {
    $aranan_urun = '%' . $_GET['urun_ad'] . '%';
    $urunarama = $db->prepare("SELECT u.*, k.kategori_ad
                               FROM urun u
                               INNER JOIN kategori k ON u.kategori_id = k.kategori_id
                               WHERE u.urun_ad LIKE :aranan
                               OR u.urun_detay LIKE :aranan
                               OR k.kategori_ad LIKE :aranan");
    $urunarama->execute(array(':aranan' => $aranan_urun));

    echo '<div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">
            <div class="row">
                <ol class="breadcrumb">
                    <li><a href="#"><em class="fa fa-home"></em></a></li>
                    <li class="active">Ürün Listesi</li>
                </ol>
            </div><!--/.row-->
            
            <div class="row">
                <div class="col-lg-12">
                    <h1 class="page-header text-center">Ürün Listesi</h1>
                </div>
            </div><!--/.row-->

            <div class="row">
                <div class="col-md-15">
                    <div class="panel panel-default articles">
                        <div class="panel-heading">
                            <h4 class="text-center">Ürün Listesi</h4>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover text-center" cellspacing="0" width="100%">
                                <thead class="table-dark">
                                    <tr>
                                        <th style="width: 5%;">Sıra No</th>
                                        <th style="width: 15%;">Ürün İsmi</th>
                                        <th style="width: 10%;">Stok</th>
                                        <th style="width: 10%;">Fiyat</th>
                                        <th style="width: 8%;">Durum</th>
                                        <th style="width: 10%;">Kategori</th>
                                        <th style="width: 20%;">Bilgi</th>
                                        <th style="width: 10%;">Seri No</th>
                                        <th style="width: 6%;">Düzenle</th>
                                        <th style="width: 6%;">Sil</th>
                                        <th style="width: 6%;">Arttır</th>
                                        <th style="width: 6%;">Azalt</th>
                                    </tr>
                                </thead>
                                <tbody>';

    while ($veri = $urunarama->fetch(PDO::FETCH_ASSOC)) {
        echo '<tr>
                <td>' . $veri['urun_id'] . '</td>
                <td>' . $veri['urun_ad'] . '</td>
                <td>' . $veri['urun_stok'] . '</td>
                <td>' . $veri['urun_fiyat'] . ' TL</td>
                <td>' . ($veri['urun_durum'] == 1 ? '<button class="btn btn-success btn-xs"> Aktif </button>' : '<button class="btn btn-danger btn-xs"> Pasif </button>') . '</td>
                <td><strong>' . $veri['kategori_ad'] . '</strong></td>
                <td>' . $veri['urun_detay'] . '</td>
                <td>' . $veri['urun_serino'] . '</td>
                <td><a href="urun-duzenle.php?urun_id=' . $veri['urun_id'] . '"><button class="btn btn-primary btn-xs">Düzenle</button></a></td>
                <td><a href="../kariyersoft/control.php?urun_id=' . $veri['urun_id'] . '&urundelete=ok"><button class="btn btn-danger btn-xs">Sil</button></a></td>
                <td><a href="../kariyersoft/control.php?urun_id=' . $veri['urun_id'] . '&arttir=1"><button class="btn btn-success btn-xs">Arttır</button></a></td>
                <td><a href="../kariyersoft/control.php?urun_id=' . $veri['urun_id'] . '&azalt=1"><button class="btn btn-danger btn-xs">Azalt</button></a></td>
            </tr>';
    }

    echo '</tbody>
            </table>
        </div>
    </div>
</div><!--/.col-->
</div><!--/.row-->
</div> <!--/.main-->';
} else {
    echo '<div class="alert alert-warning text-center"><strong>Lütfen bir ürün adı girin.</strong></div>';
}
include 'footer.php';
?>
