<?php
include 'header.php';

// Sayfa numarası ve sayfa başına personel sayısı
$sayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$sayfaBasipersonel = 20;
$limit = ($sayfa - 1) * $sayfaBasipersonel;

// Personel bilgilerini çekme işlemi
$personelsor = $db->prepare("SELECT personel_id, personel_ad, personel_detay FROM personel ORDER BY personel_ad ASC LIMIT :limit, :sayfaBasipersonel");
$personelsor->bindParam(':limit', $limit, PDO::PARAM_INT);
$personelsor->bindParam(':sayfaBasipersonel', $sayfaBasipersonel, PDO::PARAM_INT);
$personelsor->execute();

// Toplam personel sayısını öğrenme (sayfalama için)
$toplampersonel = $db->prepare("SELECT COUNT(*) FROM personel");
$toplampersonel->execute();
$toplampersonel = $toplampersonel->fetchColumn();
$sayfaSayisi = ceil($toplampersonel / $sayfaBasipersonel);
?>

<div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">
    <div class="row">
        <ol class="breadcrumb">
            <li><a href="#"><em class="fa fa-home"></em></a></li>
            <li class="active">Personel Ayarları</li>
        </ol>
    </div><!--/.row-->

    <div class="row">
        <div class="col-lg-12">
            <h1 class="page-header">Personel Ayarları</h1>
        </div>
    </div><!--/.row-->

    <div class="text-right mb-3">
        <a href="../kariyersoft/control.php?sil=all" class="btn btn-danger" style="margin-right: 10px;">Tüm Personeli Sil</a>
        <a href="personel-ekle.php" class="btn btn-success" style="margin-right: 10px;">Yeni Personel Ekle</a>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h4 style="display: inline-block;">Personel Listesi</h4>
                </div>
                
                <div class="table-responsive">
                    <table id="datatable-responsive" class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>Personel ID</th>
                                <th>Personel Adı</th>
                                <th>Personel Bilgisi</th>
                                <th>Düzenle</th>
                                <th>Sil</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($veri = $personelsor->fetch(PDO::FETCH_ASSOC)) { ?>
                                <tr>
                                    <td><?php echo $veri['personel_id']; ?></td>
                                    <td><?php echo $veri['personel_ad']; ?></td>
                                    <td><?php echo $veri['personel_detay']; ?></td>
                                    <td><a href="personel-duzenle.php?personel_id=<?php echo $veri['personel_id']; ?>" class="btn btn-warning btn-sm">Düzenle</a></td>
                                    <td><a href="../kariyersoft/control.php?personel_id=<?php echo $veri['personel_id']; ?>&personel_sil=ok" class="btn btn-danger btn-sm">Sil</a></td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>

                <div class="panel-footer">
                    <div class="text-right">
                        <ul class="pagination">
                            <?php for ($i = 1; $i <= $sayfaSayisi; $i++) { ?>
                                <li class="<?php echo $sayfa == $i ? 'active' : ''; ?>">
                                    <a href="?sayfa=<?php echo $i; ?>"><?php echo $i; ?></a>
                                </li>
                            <?php } ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div><!--/.row-->
</div><!--/.main-->

<?php include 'footer.php'; ?>
