<?php
include 'header.php';

// personel_id'yi kontrol et ve tanımla
$personel_id = isset($_GET['personel_id']) ? $_GET['personel_id'] : null;

$personelcek = null; // Ürün bilgisi başlangıçta boş

if ($personel_id !== null) {
    // Veritabanından personel sorgulama
    $personelsor = $db->prepare("SELECT * FROM personel WHERE personel_id=:id");
    $personelsor->execute(array('id' => $personel_id));

    // Personelin var olup olmadığını kontrol et
    $personelcek = $personelsor->fetch(PDO::FETCH_ASSOC);
}

// Eğer personel yoksa veya personel ID'si geçersizse hata mesajı göster
if ($personelcek === false) {
    echo "<div class='alert alert-danger'>Personel bulunamadı veya geçersiz bir personel ID'si verildi.</div>";
    exit;
}

// Kategori sorgusu
$kategorisor = $db->prepare("SELECT * FROM kategori WHERE kategori_ust=:kategori_ust ORDER BY kategori_sira");
$kategorisor->execute(array('kategori_ust' => 0));

// Firma sorgusu
$firmasor = $db->prepare("SELECT * FROM firma ORDER BY firma_ad");
$firmasor->execute();
?>

<script src="https://cdn.ckeditor.com/4.15.1/standard/ckeditor.js"></script>
<div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">
    <div class="row">
        <ol class="breadcrumb">
            <li><a href="#"><em class="fa fa-home"></em></a></li>
            <li class="active">Personel Ayarları</li>
        </ol>
    </div><!--/.row-->

    <div class="row">
        <div class="col-lg-12">
            <h1 class="page-header">Personel Ayarları</h1>
        </div>
    </div><!--/.row-->

    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <?php echo $personel_id !== null ? 'Personeli Güncelle' : 'Yeni Personel Ekle'; ?>
                    <?php if (isset($_GET['durum'])): ?>
                        <div class="pull-right">
                            <span class="label label-<?php echo ($_GET['durum'] == "ok") ? 'success' : 'danger'; ?>">
                                <?php echo ($_GET['durum'] == "ok") ? 'İşlem Başarılı' : 'İşlem Başarısız'; ?>
                            </span>
                        </div>
                    <?php endif; ?>
                </div>

                <div class="panel-body">
                    <form action="../kariyersoft/control.php" method="POST" enctype="multipart/form-data" data-parsley-validate class="form-horizontal form-label-left">

                        <!-- Personel Adı -->
                        <div class="form-group">
                            <label class="col-md-3 control-label" for="personel_ad">Personel Adı *</label>
                            <div class="col-md-9">
                                <input id="personel_ad" name="personel_ad" type="text" placeholder="Personel Adını Girin" class="form-control" value="<?php echo htmlspecialchars($personelcek['personel_ad'] ?? ''); ?>" required>
                            </div>
                        </div>                                             

                        <fieldset>
                            <!-- Personel Bilgisi -->
                            <div class="form-group">
                                <label class="col-md-3 control-label" for="personel_detay">Personel Bilgisi *</label>
                                <div class="col-md-9">
                                    <textarea class="ckeditor" id="editor1" name="personel_detay"><?php echo htmlspecialchars($personelcek['personel_detay'] ?? ''); ?></textarea>
                                </div>
                            </div>

                            <script type="text/javascript">
                                CKEDITOR.replace('editor1', {
                                    filebrowserBrowseUrl: 'ckfinder/ckfinder.html',
                                    filebrowserImageBrowseUrl: 'ckfinder/ckfinder.html?type=Images',
                                    filebrowserFlashBrowseUrl: 'ckfinder/ckfinder.html?type=Flash',
                                    filebrowserUploadUrl: 'ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files',
                                    filebrowserImageUploadUrl: 'ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Images',
                                    filebrowserFlashUploadUrl: 'ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Flash',
                                    forcePasteAsPlainText: true
                                });
                            </script>

                           

                            <!-- Ürün Durum -->
                            <div class="form-group">
                                <label class="col-md-3 control-label" for="personel_durum">Personel Durum *</label>
                                <div class="col-md-9">
                                    <select id="personel_durum" class="form-control" name="personel_durum" required>
                                        <option value="1" <?php echo (isset($personelcek['personel_durum']) && $personelcek['personel_durum'] == 1) ? 'selected' : ''; ?>>Aktif</option>
                                        <option value="0" <?php echo (isset($personelcek['personel_durum']) && $personelcek['personel_durum'] == 0) ? 'selected' : ''; ?>>Pasif</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Form actions -->
                            <div class="form-group">
                                <div class="col-md-12 widget-right">
                                    <button type="submit" name="personelekle" class="btn btn-success btn-md pull-right">Kaydet</button>
                                    <button type="reset" class="btn btn-danger btn-md pull-right" style="margin-right: 10px;">Temizle</button>
                                </div>
                            </div>
                        </fieldset>
                    </form>
                </div>
            </div>
        </div><!--/.col-->
    </div><!--/.row-->
</div><!--/.main-->

<?php include 'footer.php'; ?>
