<?php
include '../kariyersoft/config.php';
include 'fonksiyon.php';

error_reporting(E_ALL);
ini_set("display_errors", 1);

// Ayarlar tablosundan veriyi çekme
$verisor = $db->prepare("SELECT * FROM settings WHERE settings_id = :id");
$verisor->execute(['id' => 0]);
$vericek = $verisor->fetch(PDO::FETCH_ASSOC);

// Müşteri tablosundan veriyi çekme
$musterisor = $db->prepare("SELECT * FROM musteri WHERE musteri_id = :id");
$musterisor->execute(['id' => 0]);
$mustericek = $musterisor->fetch(PDO::FETCH_ASSOC);

// Admin tablosundan veriyi çekme
if (isset($_SESSION['admin_mail'])) {
    $adminsor = $db->prepare("SELECT * FROM admin WHERE admin_mail = :mail");
    $adminsor->execute(['mail' => $_SESSION['admin_mail']]);
    $admincek = $adminsor->fetch(PDO::FETCH_ASSOC);

    // Oturum kontrolü
    if ($adminsor->rowCount() == 0) {
        header("Location: login.php?durum=izinsizgiris");
        exit;
    }
} else {
    header("Location: login.php?durum=izinsizgiris");
    exit;
}

// Şu anki sayfa ismini alma
$current_page = basename($_SERVER['PHP_SELF']);
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>MaSoft - Stok Takip</title>
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="css/font-awesome.min.css" rel="stylesheet">
    <link href="css/datepicker3.css" rel="stylesheet">
    <link href="css/styles.css" rel="stylesheet">
    <link href="vendor/dropzone/dist/min/dropzone.min.css" rel="stylesheet">
    <script src="vendor/dropzone/dist/min/dropzone.min.js"></script>
    <link href="https://fonts.googleapis.com/css?family=Montserrat:300,400,500,600,700" rel="stylesheet">
    <style>
        body {
            font-family: 'Montserrat', sans-serif;
        }
        .navbar-custom {
            background-color: #2c3e50; /* Navbar rengi */
            color: white;
        }
        .sidebar {
            background-color: #34495e; /* Sidebar rengi */
            color: white;
            padding: 15px 0;
            height: 100vh; /* Tüm yüksekliği kaplar */
        }
        .sidebar .nav > li > a {
            color: #ecf0f1; /* Menü bağlantı rengi */
            padding: 10px 15px;
        }
        .sidebar .nav > li > a:hover {
            background-color: #2c3e50; /* Hover rengi */
            color: white; /* Hover metin rengi */
        }
        .sidebar .nav > li.active > a {
            background-color: #1abc9c; /* Aktif menü rengi */
            color: white; /* Aktif metin rengi */
        }
        .profile-userpic img {
            border-radius: 50%;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-custom navbar-fixed-top" role="navigation">
        <div class="container-fluid">
            <div class="navbar-header">
                <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#sidebar-collapse">
                    <span class="sr-only">Toggle navigation</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
                <a class="navbar-brand" href="#"><span>STOK</span> TAKİP</a>
            </div>
        </div><!-- /.container-fluid -->
    </nav>

    <div id="sidebar-collapse" class="col-sm-3 col-lg-2 sidebar">
        <div class="profile-sidebar">
            <div class="profile-userpic">
                <img src="http://placehold.it/50/30a5ff/fff" class="img-responsive" alt="">
            </div>
            <div class="profile-usertitle">
                <div class="profile-usertitle-name"><?php echo htmlspecialchars($admincek['admin_adsoyad'] ?? ''); ?></div>
                <div class="profile-usertitle-status"><span class="indicator label-success"></span>Aktif</div>
            </div>
            <div class="clear"></div>
        </div>
        <div class="divider"></div>

        <form role="search" method="GET" action="search.php" class="mb-4">
            <div class="form-group">
                <input type="text" class="form-control" placeholder="Ürün Ara" name="urun_ad">
            </div>
            <button type="submit" class="btn btn-primary">Ara</button>
        </form>

        <ul class="nav menu">
    <li <?php echo ($current_page == 'index.php') ? 'class="active"' : ''; ?>>
        <a href="index.php"><em class="fa fa-home" style="color: #1abc9c;">&nbsp;</em> Ana Sayfa</a>
    </li>
    <li <?php echo ($current_page == 'urun.php') ? 'class="active"' : ''; ?>>
        <a href="urun.php"><em class="fa fa-th-large" style="color: #3498db;">&nbsp;</em> Ürünler</a>
    </li>
    <li <?php echo ($current_page == 'firma.php') ? 'class="active"' : ''; ?>>
        <a href="firma.php"><em class="fa fa-building" style="color: #e67e22;">&nbsp;</em> Firmalar</a>
    </li>
    <li <?php echo ($current_page == 'personel.php') ? 'class="active"' : ''; ?>>
        <a href="personel.php"><em class="fa fa-users" style="color: #9b59b6;">&nbsp;</em> Personeller</a>
    </li>
    <li <?php echo ($current_page == 'personel-ekle.php') ? 'class="active"' : ''; ?>>
        <a href="personel-ekle.php"><em class="fa fa-user-plus" style="color: #2ecc71;">&nbsp;</em> Personel Ekle</a>
    </li>
    <li <?php echo ($current_page == 'urun-ekle.php') ? 'class="active"' : ''; ?>>
        <a href="urun-ekle.php"><em class="fa fa-plus-circle" style="color: #f39c12;">&nbsp;</em> Ürün Ekle</a>
    </li>
    <li <?php echo ($current_page == 'firma-ekle.php') ? 'class="active"' : ''; ?>>
        <a href="firma-ekle.php"><em class="fa fa-plus-square" style="color: #e74c3c;">&nbsp;</em> Firma Ekle</a>
    </li>
    <li <?php echo ($current_page == 'malzeme.php') ? 'class="active"' : ''; ?>>
        <a href="malzeme.php"><em class="fa fa-cogs" style="color: #e67e22;">&nbsp;</em> Kullanılan Malzemeler</a>
    </li>
    <li <?php echo ($current_page == 'talep.php') ? 'class="active"' : ''; ?>>
        <a href="talep.php"><em class="fa fa-shopping-cart" style="color: #2980b9;">&nbsp;</em> Sipariş Talep Formu Oluştur</a>
    </li>
    <li <?php echo ($current_page == 'kategori.php') ? 'class="active"' : ''; ?>>
        <a href="kategori.php"><em class="fa fa-tags" style="color: #d35400;">&nbsp;</em> Kategoriler</a>
    </li>
    <li <?php echo ($current_page == 'dosya-yukle.php') ? 'class="active"' : ''; ?>>
        <a href="dosya-yukle.php"><em class="fa fa-upload" style="color: #27ae60;">&nbsp;</em> Excel Dosya Yükle</a>
    </li>
    <li <?php echo ($current_page == 'logout.php') ? 'class="active"' : ''; ?>>
        <a href="logout.php"><em class="fa fa-sign-out-alt" style="color: #c0392b;">&nbsp;</em> Çıkış Yap</a>
    </li>
</ul>

    </div><!--/.sidebar-->

    <div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">
        <!-- Ana içerik buraya gelecek -->
        <h1 class="page-header">Ana Sayfa</h1>
    </div><!--/.main-->

    <script src="js/jquery-1.11.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/chart.min.js"></script>
    <script src="js/chart-data.js"></script>
    <script src="js/easypiechart.js"></script>
    <script src="js/easypiechart-data.js"></script>
    <script src="js/bootstrap-datepicker.js"></script>
    <script src="js/custom.js"></script>
</body>
</html>
