<?php
include 'header.php';
require 'vendor/autoload.php'; // PhpSpreadsheet kütüphanesini ekleyin

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Hata raporlamasını aç
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Seçilen ürünleri ve adet bilgilerini al
    $secilen_urunler = $_POST['secilen_urunler'] ?? [];
    $adetler = $_POST['adet'] ?? [];

    // Dosya adı ve yolunu belirle
    $dosyaAdi = 'Siparis_Talep_Formu.xlsx';

    // Veritabanından gerekli bilgileri al
    $veriler = array();
    $toplamFiyatlar = 0;

    foreach ($secilen_urunler as $urun_id) {
        // Ürün sorgusu
        $urun_sorgu = $db->prepare("SELECT urun_id, urun_ad, urun_fiyat, kategori.kategori_ad 
                                    FROM urun 
                                    INNER JOIN kategori ON urun.kategori_id = kategori.kategori_id 
                                    WHERE urun_id = :urun_id");
        $urun_sorgu->execute(['urun_id' => $urun_id]);
        $urun = $urun_sorgu->fetch(PDO::FETCH_ASSOC);

        // Eğer ürün veritabanında yoksa, hatayla karşılaşmamak için kontrol edelim
        if (!$urun) {
            continue; // Bu ürünü atla, çünkü veritabanında yok
        }

        // Ürün adet ve fiyat hesaplaması
        $urun_adet = isset($adetler[$urun_id]) ? (int)$adetler[$urun_id] : 0;
        if ($urun_adet <= 0) {
            continue; // Adet 0 veya negatifse atla
        }

        $birimFiyat = $urun['urun_fiyat'];
        $toplamFiyat = $birimFiyat * $urun_adet;
        $toplamFiyatlar += $toplamFiyat;

        $veriler[] = array(
            'Ürün ID' => $urun['urun_id'],
            'Ürün Adı' => $urun['urun_ad'],
            'Birim Fiyat' => $birimFiyat,
            'Kategori' => $urun['kategori_ad'],
            'Adet' => $urun_adet,
            'Toplam Fiyat' => $toplamFiyat
        );
    }

    if (empty($veriler)) {
        die('Hiçbir veri bulunamadı.'); // Veriler boşsa hata ver
    }

    // Excel dosyası oluşturma
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    // Başlık satırını ekleyin
    $sheet->fromArray(array_keys($veriler[0]), NULL, 'A1');

    // Verileri ekleyin
    $sheet->fromArray($veriler, NULL, 'A2');

    // Toplam fiyat bilgisini ekleyin
    $sonrakiSatir = count($veriler) + 3; // 3 satır aşağıda toplam fiyatı eklemek için
    $sheet->setCellValue('E' . $sonrakiSatir, 'Toplam Fiyat');
    $sheet->setCellValue('F' . $sonrakiSatir, $toplamFiyatlar);

    // Çıktı öncesi buffer temizliği
    ob_end_clean();

    // Excel dosyasını kaydet ve indirme başlat
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $dosyaAdi . '"');
    header('Cache-Control: max-age=0');

    $writer = new Xlsx($spreadsheet);
    $writer->save('php://output');
    exit;
}
?>

<?php include 'footer.php'; ?>
