<?php
include 'header.php';

// Düzenlenecek ürünün ID'sini al
$urunId = isset($_GET['urun_id']) ? (int)$_GET['urun_id'] : 0;

// Veritabanından ürün bilgilerini çek
if ($urunId > 0) {
    $urunSorgu = $db->prepare("SELECT urun_personel.*, urun.urun_ad, personel.personel_ad FROM urun_personel
        LEFT JOIN urun ON urun_personel.urun_id = urun.urun_id
        LEFT JOIN personel ON urun_personel.personel_id = personel.personel_id
        WHERE urun_personel.id = :urun_id");
    $urunSorgu->bindValue(':urun_id', $urunId, PDO::PARAM_INT);
    $urunSorgu->execute();
    $urunVeri = $urunSorgu->fetch(PDO::FETCH_ASSOC);
}

// Güncelleme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $miktar = $_POST['miktar'];
    $kullanim_yeri = $_POST['kullanim_yeri'];
    $amac = $_POST['amac'];

    $guncelleSorgu = $db->prepare("UPDATE urun_personel SET miktar = :miktar, kullanim_yeri = :kullanim_yeri, amac = :amac WHERE id = :urun_id");
    $guncelleSorgu->bindValue(':miktar', $miktar, PDO::PARAM_INT);
    $guncelleSorgu->bindValue(':kullanim_yeri', $kullanim_yeri, PDO::PARAM_STR);
    $guncelleSorgu->bindValue(':amac', $amac, PDO::PARAM_STR);
    $guncelleSorgu->bindValue(':urun_id', $urunId, PDO::PARAM_INT);

    if ($guncelleSorgu->execute()) {
        echo "<script>alert('Ürün başarıyla güncellendi.'); window.location.href = 'malzeme.php';</script>";
    } else {
        echo "<script>alert('Güncelleme işlemi sırasında bir hata oluştu.');</script>";
    }
}
?>

<div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">
    <div class="row">
        <h1 class="page-header text-center" style="color: #4CAF50;">Ürün Düzenle</h1>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="panel panel-success">
                <div class="panel-heading">
                    <h4 class="panel-title" style="text-align: center;">Ürün Bilgilerini Güncelle</h4>
                </div>
                <div class="panel-body">
                    <form method="POST">
                        <div class="form-group">
                            <label for="miktar">Miktar</label>
                            <input type="number" class="form-control" name="miktar" value="<?php echo htmlspecialchars($urunVeri['miktar']); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="kullanim_yeri">Kullanım Yeri</label>
                            <input type="text" class="form-control" name="kullanim_yeri" value="<?php echo htmlspecialchars($urunVeri['kullanim_yeri']); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="amac">Amaç</label>
                            <input type="text" class="form-control" name="amac" value="<?php echo htmlspecialchars($urunVeri['amac']); ?>" required>
                        </div>
                        <input type="hidden" name="urun_id" value="<?php echo $urunId; ?>">
                        <div class="text-center">
                            <button type="submit" class="btn btn-success">Güncelle</button>
                            <a href="malzeme.php" class="btn btn-danger">İptal</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div><!--/.main-->

<?php include 'footer.php'; ?>
