<?php
include '../kariyersoft/config.php';
require 'vendor/autoload.php'; // PhpSpreadsheet kütüphanesini ekleyin

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

// Hata raporlamasını aç
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Çıktı tamponlamasını başlat
ob_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Dosya adı ve yolunu belirle
    $dosyaAdi = 'Urun_Liste.xlsx';

    // Veritabanından ürün bilgilerini al
    $veriler = array();

    // Ürün sorgusu
    $urun_sorgu = $db->query("SELECT urun.urun_id, urun.urun_ad, kategori.kategori_ad, urun.urun_stok 
                               FROM urun 
                               INNER JOIN kategori ON urun.kategori_id = kategori.kategori_id");
    while ($urun = $urun_sorgu->fetch(PDO::FETCH_ASSOC)) {
        $veriler[] = array(
            'Ürün ID' => $urun['urun_id'],
            'Ürün Adı' => $urun['urun_ad'],
            'Kategori' => $urun['kategori_ad'],
            'Stok' => $urun['urun_stok']
        );
    }

    if (empty($veriler)) {
        die('Hiçbir veri bulunamadı.'); // Veriler boşsa hata ver
    }

    // Excel dosyası oluşturma
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();

    // Başlık satırını ekleyin
    $sheet->fromArray(array_keys($veriler[0]), NULL, 'A1');

    // Verileri ekleyin
    $sheet->fromArray($veriler, NULL, 'A2');

    // Başlık hücrelerini renklendir ve biçimlendir
    $headerStyle = [
        'fill' => [
            'fillType' => Fill::FILL_SOLID,
            'startColor' => ['rgb' => '4F81BD'], // Mavi renk
        ],
        'font' => [
            'bold' => true,
            'color' => ['rgb' => 'FFFFFF'], // Beyaz renk
            'size' => 12,
            'name' => 'Arial',
        ],
        'alignment' => [
            'horizontal' => Alignment::HORIZONTAL_CENTER,
        ],
    ];
    
    $sheet->getStyle('A1:D1')->applyFromArray($headerStyle);

    // Tüm verileri kenarlıkla kapla
    $borderStyle = [
        'borders' => [
            'allBorders' => [
                'borderStyle' => Border::BORDER_THIN,
                'color' => ['rgb' => '000000'], // Siyah kenarlık
            ],
        ],
    ];
    
    $sheet->getStyle('A1:D' . (count($veriler) + 1))->applyFromArray($borderStyle);

    // Tablonun yüksekliğini ayarlayın
    foreach (range('A', 'D') as $columnID) {
        $sheet->getColumnDimension($columnID)->setAutoSize(true); // Otomatik genişlik
    }

    // Çıktı öncesi buffer temizliği
    ob_end_clean();

    // Excel dosyasını kaydet ve indirme başlat
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $dosyaAdi . '"');
    header('Cache-Control: max-age=0');

    $writer = new Xlsx($spreadsheet);
    $writer->save('php://output');
    exit;
}
?>

<?php include 'footer.php'; ?>
